<?php

/***********************************************************
* PHP Class for UDP Magic Packet Wake-on-Lan (for Linux)   *
* For scribe auto deploy Oscar with auto boot BY JEFF      *
************************************************************/

class MagicPacket
{
function MagicPacket()
{
$this -> $ff = chr(0xFF);
}

function wake($ip, $mac, $port)
{
$this -> $nic = fsockopen("udp://" . $ip, $port);
if( !$this -> $nic )
{
fclose($this -> $nic);
return false;
}
else
{
fwrite($this -> $nic, $this -> generate_magic_packet($mac));
fclose($this -> $nic);
return true;
}
}

function generate_magic_packet($dest_mac)
{
$packet = "";
for($i = 0; $i < 6; $i++)
{
$packet .= chr(0xFF);
}

$packet2 = "";
for($j = 0; $j < 16; $j++)
{
for($i = 0; $i < 12; $i+=2)
{
$packet2 .= chr(hexdec(substr($dest_mac, $i, 2)));
}
}
$packet .= $packet2;
return $packet;
}
}
?>



<?php
$mp = new MagicPacket();
if ($mp->wake($ip, $mac, 9))
echo "Magic Packet sent to $mac@$ip";
?> 
